<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

// THIS IS A SINGLETON TABLE. ONLY 1 ROW IS EXPECTED HERE.

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('globals', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->string('organization_name', 191);
            $table->string('timezone', 191)->default('Africa/Cairo');
            $table->string('organization_address', 191);
            $table->smallInteger('absence_limit')->unsigned();
            $table->tinyInteger('payroll_day')->unsigned()->default(1);
            $table->json('weekend_off_days')->notNullable(); // Remove the default value
            $table->string('email', 191);
            $table->double('income_tax', 8, 2)->unsigned()->default(14);
            $table->tinyInteger('is_ip_based')->unsigned()->default(0);
            $table->json('ip')->nullable();
            $table->timestamps();
        });
        

        // Add a check constraint to enforce only one record
        //DB::statement('ALTER TABLE globals ADD CONSTRAINT singleton_constraint CHECK (id = 1)'); // Does not work with MySQL

        // Add a check constraint to ensure income tax is a percentage
        DB::statement('ALTER TABLE globals ADD CONSTRAINT chk_income_tax_range CHECK (income_tax >= 0 AND income_tax <= 100)');

    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('globals');
    }
};
