import { Method, Progress, VisitOptions } from '@inertiajs/core';
interface InertiaFormProps<TForm extends Record<string, unknown>> {
    isDirty: boolean;
    errors: Partial<Record<keyof TForm, string>>;
    hasErrors: boolean;
    processing: boolean;
    progress: Progress | null;
    wasSuccessful: boolean;
    recentlySuccessful: boolean;
    data(): TForm;
    transform(callback: (data: TForm) => object): this;
    defaults(): this;
    defaults(field: keyof TForm, value: string): this;
    defaults(fields: Record<keyof TForm, string>): this;
    reset(...fields: (keyof TForm)[]): this;
    clearErrors(...fields: (keyof TForm)[]): this;
    setError(field: keyof TForm, value: string): this;
    setError(errors: Record<keyof TForm, string>): this;
    submit(method: Method, url: string, options?: Partial<VisitOptions>): void;
    get(url: string, options?: Partial<VisitOptions>): void;
    post(url: string, options?: Partial<VisitOptions>): void;
    put(url: string, options?: Partial<VisitOptions>): void;
    patch(url: string, options?: Partial<VisitOptions>): void;
    delete(url: string, options?: Partial<VisitOptions>): void;
    cancel(): void;
}
export type InertiaForm<TForm extends Record<string, unknown>> = TForm & InertiaFormProps<TForm>;
export default function useForm<TForm extends Record<string, unknown>>(data: TForm | (() => TForm)): InertiaForm<TForm>;
export default function useForm<TForm extends Record<string, unknown>>(rememberKey: string, data: TForm | (() => TForm)): InertiaForm<TForm>;
export {};
