"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
const utils_js_1 = require("./utils.js");
/**
 * Inject the CSS compiled with JS.
 *
 * @return {Plugin}
 */
function cssInjectedByJsPlugin({ injectCode, injectCodeFunction, jsAssetsFilterFunction, preRenderCSSCode, styleId, topExecutionPriority, useStrictCSP, } = {}) {
    //Globally so we can add it to legacy and non-legacy bundle.
    let cssToInject = '';
    let config;
    const topExecutionPriorityFlag = typeof topExecutionPriority == 'boolean' ? topExecutionPriority : true;
    const isDebug = process.env.VITE_CSS_INJECTED_BY_JS_DEBUG;
    return {
        apply: 'build',
        enforce: 'post',
        name: 'vite-plugin-css-injected-by-js',
        configResolved(_config) {
            config = _config;
        },
        generateBundle(opts, bundle) {
            return __awaiter(this, void 0, void 0, function* () {
                if (config.build.ssr) {
                    return;
                }
                const htmlFiles = Object.keys(bundle).filter((i) => i.endsWith('.html'));
                const cssAssets = Object.keys(bundle).filter((i) => bundle[i].type == 'asset' && bundle[i].fileName.endsWith('.css'));
                const allCssCode = cssAssets.reduce(function extractCssCodeAndDeleteFromBundle(previousValue, cssName) {
                    const cssAsset = bundle[cssName];
                    const cssAssetSource = typeof cssAsset.source == 'string'
                        ? cssAsset.source.replace(/(\r\n|\n|\r)+$/gm, '')
                        : cssAsset.source;
                    const result = previousValue + cssAssetSource;
                    delete bundle[cssName];
                    return result;
                }, '');
                if (allCssCode.length > 0) {
                    cssToInject = allCssCode;
                }
                for (const name of htmlFiles) {
                    const htmlChunk = bundle[name];
                    let replacedHtml = htmlChunk.source;
                    cssAssets.forEach((cssName) => {
                        replacedHtml = (0, utils_js_1.removeLinkStyleSheets)(replacedHtml, cssName);
                        htmlChunk.source = replacedHtml;
                    });
                }
                const jsAssetsFilter = typeof jsAssetsFilterFunction == 'function' ? jsAssetsFilterFunction : defaultJsAssetsFilter;
                let jsAssetTargets = [];
                if (typeof jsAssetsFilterFunction != 'function') {
                    const jsAssets = Object.keys(bundle).filter((i) => isJsOutputChunk(bundle[i]) && defaultJsAssetsFilter(bundle[i]));
                    const jsTargetFileName = jsAssets[jsAssets.length - 1];
                    if (jsAssets.length > 1) {
                        (0, utils_js_1.warnLog)(`[vite-plugin-css-injected-by-js] has identified "${jsTargetFileName}" as one of the multiple output files marked as "entry" to put the CSS injection code. However, if this is not the intended file to add the CSS injection code, you can use the "jsAssetsFilterFunction" parameter to specify the desired output file (read docs).`);
                        if (isDebug) {
                            (0, utils_js_1.debugLog)(`[vite-plugin-css-injected-by-js] identified js file targets: ${jsAssets.join(', ')}. Selected "${jsTargetFileName}".\n`);
                        }
                    }
                    // This should be always the root of the application
                    jsAssetTargets.push(bundle[jsTargetFileName]);
                }
                else {
                    const jsAssets = Object.keys(bundle).filter((i) => isJsOutputChunk(bundle[i]) && jsAssetsFilter(bundle[i]));
                    jsAssets.forEach((jsAssetKey) => {
                        jsAssetTargets.push(bundle[jsAssetKey]);
                    });
                }
                const cssInjectionCode = yield (0, utils_js_1.buildCSSInjectionCode)({
                    cssToInject: typeof preRenderCSSCode == 'function' ? preRenderCSSCode(cssToInject) : cssToInject,
                    styleId,
                    injectCode,
                    injectCodeFunction,
                    useStrictCSP,
                });
                if (jsAssetTargets.length == 0) {
                    throw new Error('Unable to locate the JavaScript asset for adding the CSS injection code. It is recommended to review your configurations.');
                }
                jsAssetTargets.forEach((jsAsset) => {
                    const appCode = jsAsset.code;
                    jsAsset.code = topExecutionPriorityFlag ? '' : appCode;
                    jsAsset.code += cssInjectionCode ? cssInjectionCode.code : '';
                    jsAsset.code += !topExecutionPriorityFlag ? '' : appCode;
                });
            });
        },
    };
}
exports.default = cssInjectedByJsPlugin;
function isJsOutputChunk(chunk) {
    return chunk.type == 'chunk' && chunk.fileName.match(/.[cm]?js$/) != null;
}
function defaultJsAssetsFilter(chunk) {
    return chunk.isEntry && !chunk.fileName.includes('polyfill');
}
